#ifndef LINEAR_SOLVER_HPP
#define LINEAR_SOLVER_HPP

#include <algebra/CRSMatrix.hpp>
#include <algebra/LinearSolverOptions.hpp>
#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>
#include <algebra/Vector.hpp>
#include <utils/Exceptions.hpp>

class LinearSolver
{
 private:
  struct Internals;

  const LinearSolverOptions m_options;

  void _solveLocalDense(size_t N, const double* A, double* x, const double* b);

 public:
  bool hasLibrary(LSLibrary library) const;
  void checkOptions(const LinearSolverOptions& options) const;

  void solveLocalSystem(const CRSMatrix<double, size_t>& A, Vector<double>& x, const Vector<double>& b);

  template <size_t N>
  void
  solveLocalSystem(const TinyMatrix<N>& A, TinyVector<N>& x, const TinyVector<N>& b)
  {
    this->_solveLocalDense(N, &A(0, 0), &x[0], &b[0]);
  }

  LinearSolver();
  LinearSolver(const LinearSolverOptions& options);
};

#endif   // LINEAR_SOLVER_HPP
