#include <BuildInfo.hpp>
#include <pugs_build_info.hpp>
#include <pugs_config.hpp>

#include <sstream>

#ifdef PUGS_HAS_MPI
#include <mpi.h>
#endif   //  PUGS_HAS_MPI

std::string
BuildInfo::type()
{
  return PUGS_BUILD_TYPE;
}

std::string
BuildInfo::compiler()
{
  std::stringstream compiler_info;
  compiler_info << PUGS_BUILD_COMPILER << " (" << PUGS_BUILD_COMPILER_VERSION << ")" << std::ends;
  return compiler_info.str();
}

std::string
BuildInfo::kokkosDevices()
{
  return PUGS_BUILD_KOKKOS_DEVICES;
}

std::string
BuildInfo::mpiLibrary()
{
#ifdef PUGS_HAS_MPI
  return []() {
    int length;
    char mpi_version[MPI_MAX_LIBRARY_VERSION_STRING];
    MPI_Get_library_version(mpi_version, &length);
    return std::string(mpi_version);
  }();
#else
  return "none";
#endif   // PUGS_HAS_MPI
}
