#ifndef ARRAY_UTILS_HPP
#define ARRAY_UTILS_HPP

#include <PastisMacros.hpp>
#include <PastisUtils.hpp>

template <typename ArrayType>
class Min
{
 private:
  const ArrayType& m_array;
  using data_type = std::remove_const_t<typename ArrayType::data_type>;
  using index_type = typename ArrayType::index_type;

 public:
  PASTIS_INLINE
  operator data_type()
  {
    data_type reduced_value;
    parallel_reduce(m_array.size(), *this, reduced_value);
    return reduced_value;
  }

  PASTIS_INLINE
  void operator()(const index_type& i, data_type& data) const
  {
    if (m_array[i] < data) {
      data = m_array[i];
    }
  }

  PASTIS_INLINE
  void join(volatile data_type& dst,
            const volatile data_type& src) const
  {
    if (src < dst) {
      dst = src;
    }
  }

  PASTIS_INLINE
  void init(data_type& value) const
  {
    value = std::numeric_limits<data_type>::max();
  }

  PASTIS_INLINE
  Min(const ArrayType& array)
      : m_array(array)
  {
    ;
  }

  PASTIS_INLINE
  ~Min() = default;
};


template <typename ArrayType>
class Max
{
 private:
  const ArrayType& m_array;
  using data_type = std::remove_const_t<typename ArrayType::data_type>;
  using index_type = typename ArrayType::index_type;

 public:
  PASTIS_INLINE
  operator data_type()
  {
    data_type reduced_value;
    parallel_reduce(m_array.size(), *this, reduced_value);
    return reduced_value;
  }

  PASTIS_INLINE
  void operator()(const index_type& i, data_type& data) const
  {
    if (m_array[i] > data) {
      data = m_array[i];
    }
  }

  PASTIS_INLINE
  void join(volatile data_type& dst,
            const volatile data_type& src) const
  {
    if (src > dst) {
      dst = src;
    }
  }

  PASTIS_INLINE
  void init(data_type& value) const
  {
    value = -std::numeric_limits<data_type>::max();
  }

  PASTIS_INLINE
  Max(const ArrayType& array)
      : m_array(array)
  {
    ;
  }

  PASTIS_INLINE
  ~Max() = default;
};


template <typename DataType>
class Sum
{
 private:
  using data_type = DataType;
  const Array<data_type>& m_array;
  using index_type = typename Array<DataType>::index_type;

 public:
  PASTIS_INLINE
  operator data_type()
  {
    data_type reduced_value;
    parallel_reduce(m_array.size(), *this, reduced_value);
    return reduced_value;
  }

  PASTIS_INLINE
  void operator()(const index_type& i, data_type& data) const
  {
    data += m_array[i];
  }

  PASTIS_INLINE
  void join(volatile data_type& dst,
            const volatile data_type& src) const
  {
    dst += src;
  }

  PASTIS_INLINE
  void init(data_type& value) const
  {
    value = 0;
  }

  PASTIS_INLINE
  Sum(const Array<DataType>& array)
      : m_array(array)
  {
    ;
  }

  PASTIS_INLINE
  ~Sum() = default;
};

#endif //ARRAY_UTILS_HPP
