#ifndef CONCAT_EXPRESSION_PROCESSOR_BUILDER_HPP
#define CONCAT_EXPRESSION_PROCESSOR_BUILDER_HPP

#include <language/PEGGrammar.hpp>
#include <language/node_processor/ConcatExpressionProcessor.hpp>
#include <language/utils/ASTNodeDataTypeTraits.hpp>
#include <language/utils/IBinaryOperatorProcessorBuilder.hpp>

#include <type_traits>

template <typename B_DataT>
class ConcatExpressionProcessorBuilder final : public IBinaryOperatorProcessorBuilder
{
 public:
  ConcatExpressionProcessorBuilder() = default;

  ASTNodeDataType
  getDataTypeOfA() const
  {
    return ast_node_data_type_from<std::string>;
  }

  ASTNodeDataType
  getDataTypeOfB() const
  {
    return ast_node_data_type_from<B_DataT>;
  }

  ASTNodeDataType
  getReturnValueType() const
  {
    return ast_node_data_type_from<std::string>;
  }

  std::unique_ptr<INodeProcessor>
  getNodeProcessor(ASTNode& node) const
  {
    return std::make_unique<ConcatExpressionProcessor<B_DataT>>(node);
  }
};

#endif   // CONCAT_EXPRESSION_PROCESSOR_BUILDER_HPP
