#include <language/modules/BinaryOperatorRegisterForVh.hpp>

#include <language/modules/SchemeModule.hpp>
#include <language/utils/BinaryOperatorProcessorBuilder.hpp>
#include <language/utils/DataHandler.hpp>
#include <language/utils/DataVariant.hpp>
#include <language/utils/EmbeddedIDiscreteFunctionOperators.hpp>
#include <language/utils/OperatorRepository.hpp>
#include <scheme/IDiscreteFunction.hpp>

void
BinaryOperatorRegisterForVh::_register_plus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>, bool,
                                                    std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    int64_t, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    uint64_t, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>, double,
                                                    std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, bool>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, int64_t>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, uint64_t>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, double>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyVector<1>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyVector<2>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyVector<3>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyMatrix<1>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyMatrix<2>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyMatrix<3>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyVector<1>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyVector<2>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyVector<3>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyMatrix<1>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyMatrix<2>>>());

  repository.addBinaryOperator<language::plus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::plus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyMatrix<3>>>());
}

void
BinaryOperatorRegisterForVh::_register_minus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>, bool,
                                                    std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    int64_t, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    uint64_t, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    double, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, bool>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, int64_t>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, uint64_t>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, double>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyVector<1>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyVector<2>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyVector<3>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyMatrix<1>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyMatrix<2>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyMatrix<3>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyVector<1>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyVector<2>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyVector<3>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyMatrix<1>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyMatrix<2>>>());

  repository.addBinaryOperator<language::minus_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::minus_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyMatrix<3>>>());
}

void
BinaryOperatorRegisterForVh::_register_multiply()
{
  OperatorRepository& repository = OperatorRepository::instance();

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    bool, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    int64_t, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    uint64_t, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    double, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyMatrix<1>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyMatrix<2>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    TinyMatrix<3>, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyVector<1>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyVector<2>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyVector<3>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyMatrix<1>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyMatrix<2>>>());

  repository.addBinaryOperator<language::multiply_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::multiply_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>, TinyMatrix<3>>>());
}

void
BinaryOperatorRegisterForVh::_register_divide()
{
  OperatorRepository& repository = OperatorRepository::instance();

  repository.addBinaryOperator<language::divide_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::divide_op, std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>,
                                                    std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::divide_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::divide_op, std::shared_ptr<const IDiscreteFunction>, bool,
                                                    std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::divide_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::divide_op, std::shared_ptr<const IDiscreteFunction>,
                                                    int64_t, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::divide_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::divide_op, std::shared_ptr<const IDiscreteFunction>,
                                                    uint64_t, std::shared_ptr<const IDiscreteFunction>>>());

  repository.addBinaryOperator<language::divide_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::divide_op, std::shared_ptr<const IDiscreteFunction>,
                                                    double, std::shared_ptr<const IDiscreteFunction>>>());
}

BinaryOperatorRegisterForVh::BinaryOperatorRegisterForVh()
{
  this->_register_plus();
  this->_register_minus();
  this->_register_multiply();
  this->_register_divide();
}
