#ifndef GKSNAVIER_HPP
#define GKSNAVIER_HPP

#include <mesh/MeshTraits.hpp>
#include <scheme/DiscreteFunctionVariant.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;

double gks_inv_dt(const std::shared_ptr<const DiscreteFunctionVariant>& c,
                  const std::shared_ptr<const DiscreteFunctionVariant>& U);

class GKSHandler
{
 public:
  enum class SolverType
  {
    Glace,
    Eucclhyd
  };

 private:
  struct IGKSNAVIER
  {
    virtual std::tuple<const std::shared_ptr<const ItemValueVariant>,
                       const std::shared_ptr<const ItemValueVariant>,
                       const std::shared_ptr<const ItemValueVariant>>
    compute_fluxes(const std::shared_ptr<const DiscreteFunctionVariant>& rho_v,
                   const std::shared_ptr<const DiscreteFunctionVariant>& rhoU_v,
                   const std::shared_ptr<const DiscreteFunctionVariant>& rhoE_v,
                   const std::shared_ptr<const DiscreteFunctionVariant>& tau_v,
                   const double& delta,
                   const double& dt) const = 0;

    virtual std::tuple<std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply_fluxes(const std::shared_ptr<const DiscreteFunctionVariant>& rho,
                 const std::shared_ptr<const DiscreteFunctionVariant>& rhoU,
                 const std::shared_ptr<const DiscreteFunctionVariant>& rhoE,
                 const std::shared_ptr<const ItemValueVariant>& rho_fluxes,
                 const std::shared_ptr<const ItemValueVariant>& rhoU_fluxes,
                 const std::shared_ptr<const ItemValueVariant>& rhoE_fluxes,
                 const double& dt) const = 0;

    virtual std::tuple<std::shared_ptr<const DiscreteFunctionVariant>,   // rho
                       std::shared_ptr<const DiscreteFunctionVariant>,   // rhoU
                       std::shared_ptr<const DiscreteFunctionVariant>>   // rhoE
    gksNavier(const std::shared_ptr<const DiscreteFunctionVariant>& rho_v,
              const std::shared_ptr<const DiscreteFunctionVariant>& rhoU_v,
              const std::shared_ptr<const DiscreteFunctionVariant>& rhoE_v,
              const std::shared_ptr<const DiscreteFunctionVariant>& tau_v,
              const double& delta,
              const double& dt) const = 0;

    IGKSNAVIER()                        = default;
    IGKSNAVIER(IGKSNAVIER&&)            = default;
    IGKSNAVIER& operator=(IGKSNAVIER&&) = default;

    virtual ~IGKSNAVIER() = default;
  };

  template <MeshConcept MeshType>
  class GKSNAVIER;

  std::unique_ptr<IGKSNAVIER> m_gks_navier;

 public:
  const IGKSNAVIER&
  solver() const
  {
    return *m_gks_navier;
  }

  GKSHandler(const std::shared_ptr<const MeshVariant>& mesh_v);
};

#endif   // GKSNAVIER_HPP
