#ifndef DISCRETE_FUNCTION_UTILS_HPP
#define DISCRETE_FUNCTION_UTILS_HPP

#include <scheme/DiscreteFunctionType.hpp>
#include <scheme/IDiscreteFunction.hpp>
#include <scheme/IDiscreteFunctionDescriptor.hpp>

#include <vector>

PUGS_INLINE
bool
checkDiscretizationType(const std::vector<std::shared_ptr<const IDiscreteFunction>>& discrete_function_list,
                        const DiscreteFunctionType& discrete_function_type)
{
  for (const auto& discrete_function : discrete_function_list) {
    if (discrete_function->descriptor().type() != discrete_function_type) {
      return false;
    }
  }
  return true;
}

PUGS_INLINE
std::shared_ptr<const IMesh>
getCommonMesh(const std::vector<std::shared_ptr<const IDiscreteFunction>>& discrete_function_list)
{
  std::shared_ptr<const IMesh> i_mesh;
  for (const auto& discrete_function : discrete_function_list) {
    if (not i_mesh.use_count()) {
      i_mesh = discrete_function->mesh();
    } else {
      if (i_mesh != discrete_function->mesh()) {
        return {};
      }
    }
  }
  return i_mesh;
}

std::shared_ptr<const IDiscreteFunction> shallowCopy(const std::shared_ptr<const IMesh>& mesh,
                                                     const std::shared_ptr<const IDiscreteFunction>& discrete_function);

#endif   // DISCRETE_FUNCTION_UTILS_HPP
