#ifndef NAMED_DISCRETE_FUNCTION_HPP
#define NAMED_DISCRETE_FUNCTION_HPP

#include <output/INamedDiscreteData.hpp>

#include <memory>
#include <string>

class IDiscreteFunction;

class NamedDiscreteFunction final : public INamedDiscreteData
{
 private:
  std::shared_ptr<const IDiscreteFunction> m_discrete_function;
  std::string m_name;

 public:
  Type
  type() const final
  {
    return INamedDiscreteData::Type::discrete_function;
  }

  const std::string&
  name() const final
  {
    return m_name;
  }

  const std::shared_ptr<const IDiscreteFunction>
  discreteFunction() const
  {
    return m_discrete_function;
  }

  NamedDiscreteFunction(const std::shared_ptr<const IDiscreteFunction>& discrete_function, const std::string& name)
    : m_discrete_function{discrete_function}, m_name{name}
  {}

  NamedDiscreteFunction(const NamedDiscreteFunction&) = default;
  NamedDiscreteFunction(NamedDiscreteFunction&&)      = default;

  NamedDiscreteFunction()  = default;
  ~NamedDiscreteFunction() = default;
};

#endif   // NAMED_DISCRETE_FUNCTION_HPP
