#ifndef MESH_TRANSFORMER_HPP
#define MESH_TRANSFORMER_HPP

class IMesh;

template <typename ConnectivityType>
class Mesh;

class FunctionSymbolId;

#include <memory>

class MeshTransformer
{
  template <typename T>
  class MeshTransformation;

 public:
  std::shared_ptr<const IMesh> transform(const FunctionSymbolId& function_symbol_id,
                                         std::shared_ptr<const IMesh> p_mesh);

  MeshTransformer()  = default;
  ~MeshTransformer() = default;
};

#endif   // MESH_TRANSFORMER_HPP
