#include <analysis/QuadratureManager.hpp>
#include <language/PugsParser.hpp>
#include <mesh/DualConnectivityManager.hpp>
#include <mesh/DualMeshManager.hpp>
#include <mesh/MeshDataManager.hpp>
#include <mesh/SynchronizerManager.hpp>
#include <utils/PugsUtils.hpp>
#include <utils/RandomEngine.hpp>

int
main(int argc, char* argv[])
{
  std::string filename = initialize(argc, argv);

  SynchronizerManager::create();
  RandomEngine::create();
  QuadratureManager::create();
  MeshDataManager::create();
  DualConnectivityManager::create();
  DualMeshManager::create();

  parser(filename);

  DualMeshManager::destroy();
  DualConnectivityManager::destroy();
  MeshDataManager::destroy();
  RandomEngine::destroy();
  QuadratureManager::destroy();
  SynchronizerManager::destroy();

  finalize();

  return 0;
}
