#include <language/utils/AffectationRegisterForRn.hpp>

#include <language/utils/AffectationProcessorBuilder.hpp>
#include <language/utils/BasicAffectationRegistrerFor.hpp>
#include <language/utils/OperatorRepository.hpp>

template <size_t Dimension>
void
AffectationRegisterForRn<Dimension>::_register_eq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto Rn = ASTNodeDataType::build<ASTNodeDataType::vector_t>(Dimension);

  repository.addAffectation<
    language::eq_op>(Rn, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                     std::make_shared<AffectationFromZeroProcessorBuilder<language::eq_op, TinyVector<Dimension>>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rn),
                                     ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<Dimension>>>());
}

template <>
void
AffectationRegisterForRn<1>::_register_eq_op()
{
  constexpr size_t Dimension = 1;

  OperatorRepository& repository = OperatorRepository::instance();

  auto Rn = ASTNodeDataType::build<ASTNodeDataType::vector_t>(Dimension);

  repository.addAffectation<
    language::eq_op>(Rn, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyVector<Dimension>, bool>>());

  repository.addAffectation<
    language::eq_op>(Rn, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyVector<Dimension>, uint64_t>>());

  repository.addAffectation<
    language::eq_op>(Rn, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyVector<Dimension>, int64_t>>());

  repository.addAffectation<
    language::eq_op>(Rn, ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyVector<Dimension>, double>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rn),
                                     ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<Dimension>>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rn),
                                     ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<Dimension>>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rn),
                                     ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<Dimension>>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rn),
                                     ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<Dimension>>>());
}

template <size_t Dimension>
void
AffectationRegisterForRn<Dimension>::_register_pluseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto Rn = ASTNodeDataType::build<ASTNodeDataType::vector_t>(Dimension);

  repository
    .addAffectation<language::pluseq_op>(Rn, Rn,
                                         std::make_shared<AffectationProcessorBuilder<
                                           language::pluseq_op, TinyVector<Dimension>, TinyVector<Dimension>>>());
}

template <size_t Dimension>
void
AffectationRegisterForRn<Dimension>::_register_minuseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto Rn = ASTNodeDataType::build<ASTNodeDataType::vector_t>(Dimension);

  repository
    .addAffectation<language::minuseq_op>(Rn, Rn,
                                          std::make_shared<AffectationProcessorBuilder<
                                            language::minuseq_op, TinyVector<Dimension>, TinyVector<Dimension>>>());
}

template <size_t Dimension>
void
AffectationRegisterForRn<Dimension>::_register_multiplyeq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto Rn = ASTNodeDataType::build<ASTNodeDataType::vector_t>(Dimension);

  repository.addAffectation<language::multiplyeq_op>(Rn, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<Dimension>, bool>>());

  repository.addAffectation<language::multiplyeq_op>(Rn, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<Dimension>, uint64_t>>());

  repository.addAffectation<language::multiplyeq_op>(Rn, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<Dimension>, int64_t>>());

  repository.addAffectation<language::multiplyeq_op>(Rn, ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<Dimension>, double>>());
}

template <size_t Dimension>
AffectationRegisterForRn<Dimension>::AffectationRegisterForRn()
{
  BasicAffectationRegisterFor<TinyVector<Dimension>>{};
  this->_register_eq_op();
  this->_register_pluseq_op();
  this->_register_minuseq_op();
  this->_register_multiplyeq_op();
}

template class AffectationRegisterForRn<1>;
template class AffectationRegisterForRn<2>;
template class AffectationRegisterForRn<3>;
