#ifndef FILESYSTEM_HPP
#define FILESYSTEM_HPP

#include <utils/Exceptions.hpp>
#include <utils/PugsMacros.hpp>

#include <filesystem>

PUGS_INLINE void
createDirectoryIfNeeded(const std::string& filename)
{
  std::filesystem::path path = std::filesystem::path{filename}.parent_path();
  if (not path.empty()) {
    try {
      std::filesystem::create_directories(path);
    }
    catch (std::filesystem::filesystem_error& e) {
      throw NormalError(e.what());
    }
  }
}

#endif   // FILESYSTEM_HPP
