#ifndef EXECUTION_STAT_MANAGER_HPP
#define EXECUTION_STAT_MANAGER_HPP

#include <utils/PugsAssert.hpp>
#include <utils/Timer.hpp>

class ExecutionStatManager
{
 private:
  static ExecutionStatManager* m_instance;

  Timer m_elapse_time;
  bool m_do_print = true;

  std::string _prettyPrintTime(double seconds) const;

  void _printMaxResidentMemory() const;
  void _printElapseTime() const;
  void _printTotalCPUTime() const;

  explicit ExecutionStatManager()                   = default;
  ExecutionStatManager(ExecutionStatManager&&)      = delete;
  ExecutionStatManager(const ExecutionStatManager&) = delete;
  ~ExecutionStatManager()                           = default;

 public:
  PUGS_INLINE
  bool
  doPrint() const
  {
    return m_do_print;
  }

  PUGS_INLINE
  void
  setPrint(bool do_print)
  {
    m_do_print = do_print;
  }

  PUGS_INLINE
  static ExecutionStatManager&
  getInstance()
  {
    Assert(m_instance != nullptr);   // LCOV_EXCL_LINE
    return *m_instance;
  }

  static void printInfo();
  static void create();
  static void destroy();
};

#endif   // EXECUTION_STAT_MANAGER_HPP
