#ifndef MESH_LINE_NODE_BOUNDARY_HPP
#define MESH_LINE_NODE_BOUNDARY_HPP

#include <algebra/TinyMatrix.hpp>
#include <mesh/MeshNodeBoundary.hpp>

template <size_t Dimension>
class [[nodiscard]] MeshLineNodeBoundary final
  : public MeshNodeBoundary<Dimension>   // clazy:exclude=copyable-polymorphic
{
 public:
  static_assert(Dimension > 1, "MeshLineNodeBoundary makes only sense in dimension greater than 1");

  using Rd = TinyVector<Dimension, double>;

 private:
  const Rd m_direction;

  template <size_t MeshDimension>
  TinyVector<MeshDimension> _getDirection(const Mesh<Connectivity<MeshDimension>>&);

  void _checkBoundaryIsLine(const TinyVector<Dimension, double>& direction, const TinyVector<Dimension, double>& origin,
                            const double length, const Mesh<Connectivity<Dimension>>& mesh) const;

 public:
  template <size_t MeshDimension>
  friend MeshLineNodeBoundary<MeshDimension> getMeshLineNodeBoundary(const Mesh<Connectivity<MeshDimension>>& mesh,
                                                                     const IBoundaryDescriptor& boundary_descriptor);

  PUGS_INLINE
  const Rd& direction() const
  {
    return m_direction;
  }

  MeshLineNodeBoundary& operator=(const MeshLineNodeBoundary&) = default;
  MeshLineNodeBoundary& operator=(MeshLineNodeBoundary&&) = default;

 private:
  MeshLineNodeBoundary(const Mesh<Connectivity<Dimension>>& mesh, const RefEdgeList& ref_edge_list)
    : MeshNodeBoundary<Dimension>(mesh, ref_edge_list), m_direction(_getDirection(mesh))
  {}

  MeshLineNodeBoundary(const Mesh<Connectivity<Dimension>>& mesh, const RefFaceList& ref_face_list)
    : MeshNodeBoundary<Dimension>(mesh, ref_face_list), m_direction(_getDirection(mesh))
  {}

  MeshLineNodeBoundary(const Mesh<Connectivity<Dimension>>& mesh, const RefNodeList& ref_node_list)
    : MeshNodeBoundary<Dimension>(mesh, ref_node_list), m_direction(_getDirection(mesh))
  {}

 public:
  MeshLineNodeBoundary()                            = default;
  MeshLineNodeBoundary(const MeshLineNodeBoundary&) = default;
  MeshLineNodeBoundary(MeshLineNodeBoundary &&)     = default;
  ~MeshLineNodeBoundary()                           = default;
};

template <size_t Dimension>
MeshLineNodeBoundary<Dimension> getMeshLineNodeBoundary(const Mesh<Connectivity<Dimension>>& mesh,
                                                        const IBoundaryDescriptor& boundary_descriptor);

#endif   // MESH_LINE_NODE_BOUNDARY_HPP
