#include <language/utils/EmbeddedIDiscreteFunctionUtils.hpp>

#include <utils/Exceptions.hpp>

bool
EmbeddedIDiscreteFunctionUtils::isSameDiscretization(const IDiscreteFunction& f, const IDiscreteFunction& g)
{
  if ((f.dataType() == g.dataType()) and (f.descriptor().type() == g.descriptor().type())) {
    switch (f.dataType()) {
    case ASTNodeDataType::double_t: {
      return true;
    }
    case ASTNodeDataType::vector_t: {
      return f.dataType().dimension() == g.dataType().dimension();
    }
    case ASTNodeDataType::matrix_t: {
      return (f.dataType().numberOfRows() == g.dataType().numberOfRows()) and
             (f.dataType().numberOfColumns() == g.dataType().numberOfColumns());
    }
    default: {
      throw UnexpectedError("invalid data type " + getOperandTypeName(f));
    }
    }
  } else {
    return false;
  }
}
