#include <language/utils/AffectationRegisterForRnxn.hpp>

#include <language/utils/AffectationProcessorBuilder.hpp>
#include <language/utils/BasicAffectationRegistrerFor.hpp>
#include <language/utils/OperatorRepository.hpp>

template <size_t Dimension>
void
AffectationRegisterForRnxn<Dimension>::_register_eq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto Rnxn = ASTNodeDataType::build<ASTNodeDataType::matrix_t>(Dimension, Dimension);

  repository.addAffectation<
    language::eq_op>(Rnxn, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                     std::make_shared<AffectationFromZeroProcessorBuilder<language::eq_op, TinyMatrix<Dimension>>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rnxn),
                                     ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyMatrix<Dimension>>>());
}

template <>
void
AffectationRegisterForRnxn<1>::_register_eq_op()
{
  constexpr size_t Dimension = 1;

  OperatorRepository& repository = OperatorRepository::instance();

  auto Rnxn = ASTNodeDataType::build<ASTNodeDataType::matrix_t>(Dimension, Dimension);

  repository.addAffectation<
    language::eq_op>(Rnxn, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyMatrix<Dimension>, bool>>());

  repository.addAffectation<
    language::eq_op>(Rnxn, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyMatrix<Dimension>, uint64_t>>());

  repository.addAffectation<
    language::eq_op>(Rnxn, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyMatrix<Dimension>, int64_t>>());

  repository.addAffectation<
    language::eq_op>(Rnxn, ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyMatrix<Dimension>, double>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rnxn),
                                     ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyMatrix<Dimension>>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rnxn),
                                     ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyMatrix<Dimension>>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rnxn),
                                     ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyMatrix<Dimension>>>());

  repository
    .addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(Rnxn),
                                     ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                                     std::make_shared<AffectationToTupleProcessorBuilder<TinyMatrix<Dimension>>>());
}

template <size_t Dimension>
void
AffectationRegisterForRnxn<Dimension>::_register_pluseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto Rnxn = ASTNodeDataType::build<ASTNodeDataType::matrix_t>(Dimension, Dimension);

  repository
    .addAffectation<language::pluseq_op>(Rnxn, Rnxn,
                                         std::make_shared<AffectationProcessorBuilder<
                                           language::pluseq_op, TinyMatrix<Dimension>, TinyMatrix<Dimension>>>());
}

template <size_t Dimension>
void
AffectationRegisterForRnxn<Dimension>::_register_minuseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto Rnxn = ASTNodeDataType::build<ASTNodeDataType::matrix_t>(Dimension, Dimension);

  repository
    .addAffectation<language::minuseq_op>(Rnxn, Rnxn,
                                          std::make_shared<AffectationProcessorBuilder<
                                            language::minuseq_op, TinyMatrix<Dimension>, TinyMatrix<Dimension>>>());
}

template <size_t Dimension>
void
AffectationRegisterForRnxn<Dimension>::_register_multiplyeq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto Rnxn = ASTNodeDataType::build<ASTNodeDataType::matrix_t>(Dimension, Dimension);

  repository.addAffectation<language::multiplyeq_op>(Rnxn, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyMatrix<Dimension>, bool>>());

  repository.addAffectation<language::multiplyeq_op>(Rnxn, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyMatrix<Dimension>, uint64_t>>());

  repository.addAffectation<language::multiplyeq_op>(Rnxn, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyMatrix<Dimension>, int64_t>>());

  repository.addAffectation<language::multiplyeq_op>(Rnxn, ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyMatrix<Dimension>, double>>());
}

template <size_t Dimension>
AffectationRegisterForRnxn<Dimension>::AffectationRegisterForRnxn()
{
  BasicAffectationRegisterFor<TinyMatrix<Dimension>>{};
  this->_register_eq_op();
  this->_register_pluseq_op();
  this->_register_minuseq_op();
  this->_register_multiplyeq_op();
}

template class AffectationRegisterForRnxn<1>;
template class AffectationRegisterForRnxn<2>;
template class AffectationRegisterForRnxn<3>;
