#ifndef CONNECTIVITY_UTILS_HPP
#define CONNECTIVITY_UTILS_HPP

#include <map>
#include <Kokkos_Core.hpp>
#include <Kokkos_StaticCrsGraph.hpp>

typedef Kokkos::StaticCrsGraph<unsigned int, Kokkos::HostSpace> ConnectivityMatrix;
#warning use right type (unsigned short)
typedef Kokkos::StaticCrsGraph<unsigned int, Kokkos::HostSpace> ConnectivityMatrixShort;

class ConnectivityUtils
{
 public:
  void computeNodeCellConnectivity(const ConnectivityMatrix& cell_to_node_matrix,
                                   ConnectivityMatrix& node_to_cell_matrix,
                                   ConnectivityMatrixShort& node_to_cell_local_node_matrix)
  {
    std::map<unsigned int, std::vector<unsigned int>> node_cells_map;
    const size_t& number_of_cells = cell_to_node_matrix.numRows();

    for (unsigned int j=0; j<number_of_cells; ++j) {
      const auto& cell_nodes = cell_to_node_matrix.rowConst(j);
      for (unsigned int r=0; r<cell_nodes.length; ++r) {
        node_cells_map[cell_nodes(r)].push_back(j);
      }
    }

    {
      size_t i=0;
      for (const auto& i_cell_vector : node_cells_map) {
        const auto& [node_id, cell_vector] = i_cell_vector;
        if (node_id != i) {
          std::cerr << "sparse node numerotation NIY\n";
          std::exit(0);
        }
        ++i;
      }
    }

    std::vector<std::vector<unsigned int>> node_to_cell_vector(node_cells_map.size());
    for (const auto& i_cell_vector : node_cells_map) {
      const auto& [r, cells_vector] = i_cell_vector;
      node_to_cell_vector[r] = cells_vector;
    }
    node_to_cell_matrix
        = Kokkos::create_staticcrsgraph<ConnectivityMatrix>("node_to_cell_matrix", node_to_cell_vector);

    std::vector<std::vector<unsigned int>> node_to_cell_local_node_vector(node_cells_map.size());
    for (unsigned int r=0; r<node_cells_map.size(); ++r) {
      const auto& node_to_cell = node_to_cell_matrix.rowConst(r);
      node_to_cell_local_node_vector[r].resize(node_to_cell.length);
      for (unsigned short J=0; J<node_to_cell.length; ++J) {
        const unsigned int j = node_to_cell(J);
        const auto& cell_nodes = cell_to_node_matrix.rowConst(j);

        for (unsigned int R=0; R<cell_nodes.length; ++R) {
          if (cell_nodes(R) == r) {
            node_to_cell_local_node_vector[r][J] = R;
            break;
          }
        }
      }
    }
    node_to_cell_local_node_matrix
        = Kokkos::create_staticcrsgraph<ConnectivityMatrixShort>("node_to_cell_local_node_matrix", node_to_cell_local_node_vector);

  }
};

#endif // CONNECTIVITY_UTILS_HPP
