#ifndef MESH_LESS_ACOUSTIC_SOLVER_HPP
#define MESH_LESS_ACOUSTIC_SOLVER_HPP

#include <Kokkos_Core.hpp>

class MeshLessAcousticSolver 
{
private:

  inline double e(double rho, double p, double gamma) const;
  inline double p(double rho, double e, double gamma) const;

  inline double acoustic_dt(const Kokkos::View<const double*>& Vj,
			    const Kokkos::View<const double*>& cj) const;

  inline void computeExplicitFluxes(const Kokkos::View<const double*>& xr,
				    const Kokkos::View<const double*>& xj,
				    const Kokkos::View<const double*>& rhoj,
				    const Kokkos::View<const double*>& uj,
				    const Kokkos::View<const double*>& pj,
				    const Kokkos::View<const double*>& cj,
				    const Kokkos::View<const double*>& Vj,
				    Kokkos::View<double*>& ur,
				    Kokkos::View<double*>& pr) const;

  struct ReduceMin;
public:
  MeshLessAcousticSolver(const long int& nj);
};

#endif // MESH_LESS_ACOUSTIC_SOLVER_HPP
