#ifndef ACOUSTIC_SOLVER_TEST_HPP
#define ACOUSTIC_SOLVER_TEST_HPP

#include <Kokkos_Core.hpp>

#include <TinyVector.hpp>
#include <TinyMatrix.hpp>

constexpr static size_t dimension = 1;

typedef TinyVector<dimension> Rd;
typedef TinyMatrix<dimension> Rdd;

class AcousticSolverTest 
{
private:

  inline const Kokkos::View<const double*>
  computeRhoCj(const Kokkos::View<const double*>& rhoj,
	       const Kokkos::View<const double*>& cj);

  inline const Kokkos::View<const Rdd*[2]>
  computeAjr(const Kokkos::View<const double*>& rhocj,
	     const Kokkos::View<const Rd*[2]>& Cjr);

  inline const Kokkos::View<const Rdd*>
  computeAr(const Kokkos::View<const Rdd*[2]>& Ajr,
	    const Kokkos::View<const int*[2]>& node_cells,
	    const Kokkos::View<const int*[2]>& node_cell_local_node,
	    const Kokkos::View<const int*>& node_nb_cells);

  inline const Kokkos::View<const Rd*>
  computeBr(const Kokkos::View<const Rdd*[2]>& Ajr,
	    const Kokkos::View<const Rd*[2]>& Cjr,
	    const Kokkos::View<const Rd*>& uj,
	    const Kokkos::View<const double*>& pj,
	    const Kokkos::View<const int*[2]>& node_cells,
	    const Kokkos::View<const int*[2]>& node_cell_local_node,
	    const Kokkos::View<const int*>& node_nb_cells);

  Kokkos::View<Rd*>
  computeUr(const Kokkos::View<const Rdd*>& Ar,
	    const Kokkos::View<const Rd*>& br);

  Kokkos::View<Rd*[2]>
  computeFjr(const Kokkos::View<const Rdd*[2]>& Ajr,
	     const Kokkos::View<const Rd*>& ur,
	     const Kokkos::View<const Rd*[2]>& Cjr,
	     const Kokkos::View<const Rd*>& uj,
	     const Kokkos::View<const double*>& pj,
	     const Kokkos::View<const int*[2]>& cell_nodes);

  void inverse(const Kokkos::View<const Rdd*>& A,
	       Kokkos::View<Rdd*>& inv_A) const;

  void inverse(const Kokkos::View<const double*>& x,
	       Kokkos::View<double*>& inv_x) const;

  inline double acoustic_dt(const Kokkos::View<const double*>& Vj,
			    const Kokkos::View<const double*>& cj) const;

  inline void computeExplicitFluxes(const Kokkos::View<const Rd*>& xr,
				    const Kokkos::View<const Rd*>& xj,
				    const Kokkos::View<const double*>& rhoj,
				    const Kokkos::View<const Rd*>& uj,
				    const Kokkos::View<const double*>& pj,
				    const Kokkos::View<const double*>& cj,
				    const Kokkos::View<const double*>& Vj,
				    const Kokkos::View<const Rd*[2]>& Cjr,
				    const Kokkos::View<const int*[2]>& cell_nodes,
				    const Kokkos::View<const int*[2]>& node_cells,
				    const Kokkos::View<const int*>& node_nb_cells,
				    const Kokkos::View<const int*[2]>& node_cell_local_node,
				    Kokkos::View<Rd*>& ur,
				    Kokkos::View<Rd*[2]>& Fjr);

  struct ReduceMin;

  const size_t m_nj;
  const size_t m_nr;

  Kokkos::View<Rd*> m_br;
  Kokkos::View<Rdd*[2]> m_Ajr;
  Kokkos::View<Rdd*> m_Ar;
  Kokkos::View<Rdd*> m_inv_Ar;
  Kokkos::View<Rd*[2]> m_Fjr;
  Kokkos::View<Rd*> m_ur;
  Kokkos::View<double*> m_rhocj;
  Kokkos::View<double*> m_Vj_over_cj;


public:
  AcousticSolverTest(const long int& nj);
};

#endif // ACOUSTIC_SOLVER_TEST_HPP
