#ifndef EMBEDDED_I_DISCRETE_FUNCTION_OPERATORS_HPP
#define EMBEDDED_I_DISCRETE_FUNCTION_OPERATORS_HPP

#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>

#include <memory>

class IDiscreteFunction;

// sum
std::shared_ptr<const IDiscreteFunction> operator+(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator+(const double&, const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator+(const std::shared_ptr<const IDiscreteFunction>&, const double&);

std::shared_ptr<const IDiscreteFunction> operator+(const TinyVector<1>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator+(const TinyVector<2>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator+(const TinyVector<3>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator+(const TinyMatrix<1>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator+(const TinyMatrix<2>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator+(const TinyMatrix<3>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator+(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<1>&);

std::shared_ptr<const IDiscreteFunction> operator+(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<2>&);

std::shared_ptr<const IDiscreteFunction> operator+(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<3>&);

std::shared_ptr<const IDiscreteFunction> operator+(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<1>&);

std::shared_ptr<const IDiscreteFunction> operator+(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<2>&);

std::shared_ptr<const IDiscreteFunction> operator+(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<3>&);

// difference
std::shared_ptr<const IDiscreteFunction> operator-(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator-(const double&, const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator-(const std::shared_ptr<const IDiscreteFunction>&, const double&);

std::shared_ptr<const IDiscreteFunction> operator-(const TinyVector<1>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator-(const TinyVector<2>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator-(const TinyVector<3>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator-(const TinyMatrix<1>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator-(const TinyMatrix<2>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator-(const TinyMatrix<3>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator-(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<1>&);

std::shared_ptr<const IDiscreteFunction> operator-(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<2>&);

std::shared_ptr<const IDiscreteFunction> operator-(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<3>&);

std::shared_ptr<const IDiscreteFunction> operator-(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<1>&);

std::shared_ptr<const IDiscreteFunction> operator-(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<2>&);

std::shared_ptr<const IDiscreteFunction> operator-(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<3>&);

// product
std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const double&, const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&, const double&);

std::shared_ptr<const IDiscreteFunction> operator*(const TinyMatrix<1>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const TinyMatrix<2>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const TinyMatrix<3>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<1>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<2>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<3>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<1>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<2>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<3>&);

// ratio
std::shared_ptr<const IDiscreteFunction> operator/(const double&, const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator/(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

#endif   // EMBEDDED_I_DISCRETE_FUNCTION_OPERATORS_HPP
