#include <language/utils/AffectationRegisterForR.hpp>

#include <language/utils/AffectationProcessorBuilder.hpp>
#include <language/utils/BasicAffectationRegistrerFor.hpp>
#include <language/utils/OperatorRepository.hpp>

void
AffectationRegisterForR::_register_eq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R = ASTNodeDataType::build<ASTNodeDataType::double_t>();

  repository
    .addAffectation<language::eq_op>(R, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                                     std::make_shared<AffectationProcessorBuilder<language::eq_op, double, bool>>());

  repository.addAffectation<
    language::eq_op>(R, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, double, uint64_t>>());

  repository
    .addAffectation<language::eq_op>(R, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                     std::make_shared<AffectationProcessorBuilder<language::eq_op, double, int64_t>>());

  repository.addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(R),
                                             ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                                             std::make_shared<AffectationToTupleProcessorBuilder<double>>());

  repository.addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(R),
                                             ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                                             std::make_shared<AffectationToTupleProcessorBuilder<double>>());

  repository.addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(R),
                                             ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                             std::make_shared<AffectationToTupleProcessorBuilder<double>>());
}

void
AffectationRegisterForR::_register_pluseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R = ASTNodeDataType::build<ASTNodeDataType::double_t>();

  repository.addAffectation<
    language::pluseq_op>(R, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                         std::make_shared<AffectationProcessorBuilder<language::pluseq_op, double, bool>>());

  repository.addAffectation<
    language::pluseq_op>(R, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                         std::make_shared<AffectationProcessorBuilder<language::pluseq_op, double, uint64_t>>());

  repository.addAffectation<
    language::pluseq_op>(R, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                         std::make_shared<AffectationProcessorBuilder<language::pluseq_op, double, int64_t>>());

  repository.addAffectation<
    language::pluseq_op>(R, R, std::make_shared<AffectationProcessorBuilder<language::pluseq_op, double, double>>());
}

void
AffectationRegisterForR::_register_minuseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R = ASTNodeDataType::build<ASTNodeDataType::double_t>();

  repository.addAffectation<
    language::minuseq_op>(R, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                          std::make_shared<AffectationProcessorBuilder<language::minuseq_op, double, bool>>());

  repository.addAffectation<
    language::minuseq_op>(R, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                          std::make_shared<AffectationProcessorBuilder<language::minuseq_op, double, uint64_t>>());

  repository.addAffectation<
    language::minuseq_op>(R, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                          std::make_shared<AffectationProcessorBuilder<language::minuseq_op, double, int64_t>>());

  repository.addAffectation<
    language::minuseq_op>(R, R, std::make_shared<AffectationProcessorBuilder<language::minuseq_op, double, double>>());
}

void
AffectationRegisterForR::_register_multiplyeq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R = ASTNodeDataType::build<ASTNodeDataType::double_t>();

  repository.addAffectation<
    language::multiplyeq_op>(R, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                             std::make_shared<AffectationProcessorBuilder<language::multiplyeq_op, double, bool>>());

  repository.addAffectation<language::multiplyeq_op>(R, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, double, uint64_t>>());

  repository.addAffectation<
    language::multiplyeq_op>(R, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                             std::make_shared<AffectationProcessorBuilder<language::multiplyeq_op, double, int64_t>>());

  repository.addAffectation<
    language::multiplyeq_op>(R, R,
                             std::make_shared<AffectationProcessorBuilder<language::multiplyeq_op, double, double>>());
}

void
AffectationRegisterForR::_register_divideeq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R = ASTNodeDataType::build<ASTNodeDataType::double_t>();

  repository.addAffectation<
    language::divideeq_op>(R, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                           std::make_shared<AffectationProcessorBuilder<language::divideeq_op, double, bool>>());

  repository.addAffectation<
    language::divideeq_op>(R, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                           std::make_shared<AffectationProcessorBuilder<language::divideeq_op, double, uint64_t>>());

  repository.addAffectation<
    language::divideeq_op>(R, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                           std::make_shared<AffectationProcessorBuilder<language::divideeq_op, double, int64_t>>());

  repository.addAffectation<
    language::divideeq_op>(R, R,
                           std::make_shared<AffectationProcessorBuilder<language::divideeq_op, double, double>>());
}

AffectationRegisterForR::AffectationRegisterForR()
{
  BasicAffectationRegisterFor<double>{};
  this->_register_eq_op();
  this->_register_pluseq_op();
  this->_register_minuseq_op();
  this->_register_multiplyeq_op();
  this->_register_divideeq_op();
}
