#ifndef CFUNCTION_PROCESSOR_HPP
#define CFUNCTION_PROCESSOR_HPP

#include <PEGGrammar.hpp>

#include <node_processor/INodeProcessor.hpp>

#include <CFunctionEmbedder.hpp>

#include <node_processor/FunctionArgumentConverter.hpp>

class CFunctionExpressionProcessor final : public INodeProcessor
{
 private:
  std::shared_ptr<ICFunctionEmbedder> m_embedded_c_function;

 public:
  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    return m_embedded_c_function->apply(exec_policy.currentContext().values());
  }

  CFunctionExpressionProcessor(std::shared_ptr<ICFunctionEmbedder> embedded_c_function)
    : m_embedded_c_function(embedded_c_function)
  {}
};

class CFunctionProcessor : public INodeProcessor
{
 private:
  ASTNode& m_argument_node;

  std::unique_ptr<INodeProcessor> m_function_expression_processor;

  std::vector<std::unique_ptr<IFunctionArgumentConverter>> m_argument_converters;

 public:
  void
  addArgumentConverter(std::unique_ptr<IFunctionArgumentConverter>&& argument_converter)
  {
    m_argument_converters.emplace_back(std::move(argument_converter));
  }

  void
  setFunctionExpressionProcessor(std::unique_ptr<INodeProcessor>&& function_processor)
  {
    m_function_expression_processor = std::move(function_processor);
  }

  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    ExecutionPolicy context_exec_policy{exec_policy,
                                        ExecutionPolicy::Context{-1, std::make_shared<ExecutionPolicy::Context::Values>(
                                                                       m_argument_converters.size())}};
    if (m_argument_converters.size() == 1) {
      m_argument_converters[0]->convert(context_exec_policy, m_argument_node.execute(context_exec_policy));
    } else {
      AggregateDataVariant argument_values{
        std::get<AggregateDataVariant>(m_argument_node.execute(context_exec_policy))};

      for (size_t i = 0; i < m_argument_converters.size(); ++i) {
        m_argument_converters[i]->convert(context_exec_policy, std::move(argument_values[i]));
      }
    }

    return m_function_expression_processor->execute(context_exec_policy);
  }

  CFunctionProcessor(ASTNode& argument_node) : m_argument_node{argument_node} {}
};

#endif   // CFUNCTION_PROCESSOR_HPP
