#ifndef ARRAY_SUBSCRIPT_PROCESSOR_HPP
#define ARRAY_SUBSCRIPT_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

template <typename ArrayTypeT>
class ArraySubscriptProcessor : public INodeProcessor
{
 private:
  ASTNode& m_array_subscript_expression;

 public:
  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    auto& index_expression = *m_array_subscript_expression.children[1];

    const int64_t index_value = [&](DataVariant&& value_variant) -> int64_t {
      int64_t index_value = 0;
      std::visit(
        [&](auto&& value) {
          using ValueT = std::decay_t<decltype(value)>;
          if constexpr (std::is_integral_v<ValueT>) {
            index_value = value;
          } else {
            throw parse_error("unexpected error: invalid index type", std::vector{index_expression.begin()});
          }
        },
        value_variant);
      return index_value;
    }(index_expression.execute(exec_policy));

    auto& array_expression = *m_array_subscript_expression.children[0];

    const ArrayTypeT& array = std::get<ArrayTypeT>(array_expression.execute(exec_policy));

    return array[index_value];
  }

  ArraySubscriptProcessor(ASTNode& array_subscript_expression)
    : m_array_subscript_expression{array_subscript_expression}
  {}

  virtual ~ArraySubscriptProcessor() = default;
};

#endif   // ARRAY_SUBSCRIPT_PROCESSOR_HPP
