#ifndef MESH_MODULE_HPP
#define MESH_MODULE_HPP

#include <language/modules/BuiltinModule.hpp>
#include <language/utils/ASTNodeDataTypeTraits.hpp>
#include <utils/PugsMacros.hpp>

class IMesh;
template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const IMesh>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("mesh");

class IBoundaryDescriptor;
template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const IBoundaryDescriptor>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("boundary");

class IZoneDescriptor;
template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const IZoneDescriptor>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("zone");

class MeshModule : public BuiltinModule
{
 public:
  std::string_view
  name() const final
  {
    return "mesh";
  }

  void registerOperators() const final;

  MeshModule();

  ~MeshModule() = default;
};

#endif   // MESH_MODULE_HPP
