#ifndef DIRICHLET_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define DIRICHLET_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>

class DirichletBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "dirichlet(" << m_name << ',' << *m_boundary_descriptor << ")";
    return os;
  }

  const std::string_view m_name;

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;
  const FunctionSymbolId m_rhs_symbol_id;

 public:
  std::string_view
  name() const
  {
    return m_name;
  }

  FunctionSymbolId
  rhsSymbolId() const
  {
    return m_rhs_symbol_id;
  }

  const IBoundaryDescriptor&
  boundaryDescriptor() const final
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::dirichlet;
  }

  DirichletBoundaryConditionDescriptor(const std::string_view name,
                                       std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor,
                                       const FunctionSymbolId& rhs_symbol_id)
    : m_name{name}, m_boundary_descriptor(boundary_descriptor), m_rhs_symbol_id{rhs_symbol_id}
  {
    ;
  }

  DirichletBoundaryConditionDescriptor(const DirichletBoundaryConditionDescriptor&) = delete;
  DirichletBoundaryConditionDescriptor(DirichletBoundaryConditionDescriptor&&)      = delete;

  ~DirichletBoundaryConditionDescriptor() = default;
};

#endif   // DIRICHLET_BOUNDARY_CONDITION_DESCRIPTOR_HPP
