#include <language/utils/UnaryOperatorRegisterForN.hpp>

#include <language/utils/OperatorRepository.hpp>
#include <language/utils/UnaryOperatorProcessorBuilder.hpp>

void
UnaryOperatorRegisterForN::_register_unary_minus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto N = ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>();

  repository.addUnaryOperator<
    language::unary_minus>(N,
                           std::make_shared<UnaryOperatorProcessorBuilder<language::unary_minus, int64_t, uint64_t>>());
}

UnaryOperatorRegisterForN::UnaryOperatorRegisterForN()
{
  this->_register_unary_minus();
}
