#ifndef PRESSURE_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define PRESSURE_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>
#include <scheme/IBoundaryDescriptor.hpp>

#include <memory>

class PressureBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "pressure(" << *m_boundary_descriptor << ")";
    return os;
  }

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;
  const FunctionSymbolId m_function_symbol_id;

 public:
  FunctionSymbolId
  functionSymbolId() const
  {
    return m_function_symbol_id;
  }

  const IBoundaryDescriptor&
  boundaryDescriptor() const
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::pressure;
  }

  PressureBoundaryConditionDescriptor(std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor,
                                      const FunctionSymbolId& function_symbol_id)
    : m_boundary_descriptor(boundary_descriptor), m_function_symbol_id{function_symbol_id}
  {
    ;
  }

  PressureBoundaryConditionDescriptor(const PressureBoundaryConditionDescriptor&) = delete;
  PressureBoundaryConditionDescriptor(PressureBoundaryConditionDescriptor&&)      = delete;

  ~PressureBoundaryConditionDescriptor() = default;
};

#endif   // PRESSURE_BOUNDARY_CONDITION_DESCRIPTOR_HPP
