#ifndef I_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define I_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <iostream>

class IBoundaryConditionDescriptor
{
 public:
  enum class Type
  {
    velocity,
    pressure,
    symmetry
  };

 protected:
  virtual std::ostream& _write(std::ostream& os) const = 0;

 public:
  friend std::ostream&
  operator<<(std::ostream& os, const IBoundaryConditionDescriptor& bcd)
  {
    return bcd._write(os);
  }

  virtual Type type() const = 0;

  IBoundaryConditionDescriptor()                                    = default;
  IBoundaryConditionDescriptor(const IBoundaryConditionDescriptor&) = delete;
  IBoundaryConditionDescriptor(IBoundaryConditionDescriptor&&)      = delete;

  virtual ~IBoundaryConditionDescriptor() = default;
};

#endif   // I_BOUNDARY_CONDITION_DESCRIPTOR_HPP
