#include <language/modules/VTKModule.hpp>

#include <language/utils/BuiltinFunctionEmbedder.hpp>
#include <language/utils/TypeDescriptor.hpp>
#include <mesh/Connectivity.hpp>
#include <mesh/GmshReader.hpp>
#include <mesh/Mesh.hpp>
#include <output/VTKWriter.hpp>

VTKModule::VTKModule()
{
  this->_addBuiltinFunction("writeVTK",
                            std::make_shared<
                              BuiltinFunctionEmbedder<void(std::shared_ptr<const IMesh>, const std::string&)>>(

                              [](std::shared_ptr<const IMesh> p_mesh, const std::string& filename) -> void {
                                VTKWriter writer(filename, 0.1);

                                static double time = 0;

                                switch (p_mesh->dimension()) {
                                case 1: {
                                  using MeshType       = Mesh<Connectivity<1>>;
                                  const MeshType& mesh = dynamic_cast<const MeshType&>(*p_mesh);

                                  writer.write(mesh, OutputNamedItemValueSet{}, time, true);
                                  break;
                                }
                                case 2: {
                                  using MeshType       = Mesh<Connectivity<2>>;
                                  const MeshType& mesh = dynamic_cast<const MeshType&>(*p_mesh);

                                  writer.write(mesh, OutputNamedItemValueSet{}, time, true);
                                  break;
                                }
                                case 3: {
                                  using MeshType       = Mesh<Connectivity<3>>;
                                  const MeshType& mesh = dynamic_cast<const MeshType&>(*p_mesh);

                                  writer.write(mesh, OutputNamedItemValueSet{}, time, true);
                                  break;
                                }
                                }

                                time++;
                              }

                              ));
}
