#ifndef AXIS_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define AXIS_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>

class AxisBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "axis(" << *m_boundary_descriptor << ")";
    return os;
  }

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;

 public:
  const IBoundaryDescriptor&
  boundaryDescriptor() const final
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::axis;
  }

  AxisBoundaryConditionDescriptor(std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor)
    : m_boundary_descriptor(boundary_descriptor)
  {
    ;
  }

  AxisBoundaryConditionDescriptor(const AxisBoundaryConditionDescriptor&) = delete;
  AxisBoundaryConditionDescriptor(AxisBoundaryConditionDescriptor&&)      = delete;

  ~AxisBoundaryConditionDescriptor() = default;
};

#endif   // AXIS_BOUNDARY_CONDITION_DESCRIPTOR_HPP
