#ifndef PUGS_TRAITS_HPP
#define PUGS_TRAITS_HPP

#include <cstddef>
#include <memory>
#include <type_traits>
#include <vector>

template <size_t N, typename T>
class TinyVector;
template <size_t N, typename T>
class TinyMatrix;

// Traits is_trivially_castable

template <typename T>
inline constexpr bool is_trivially_castable = std::is_trivial_v<T>;

template <size_t N, typename T>
inline constexpr bool is_trivially_castable<TinyVector<N, T>> = is_trivially_castable<T>;
template <size_t N, typename T>
inline constexpr bool is_trivially_castable<const TinyVector<N, T>> = is_trivially_castable<T>;

template <size_t N, typename T>
inline constexpr bool is_trivially_castable<TinyMatrix<N, T>> = is_trivially_castable<T>;
template <size_t N, typename T>
inline constexpr bool is_trivially_castable<const TinyMatrix<N, T>> = is_trivially_castable<T>;

// Traits is_false

template <typename T>
inline constexpr bool is_false_v = false;

// Traits is_shared_ptr

template <typename T>
inline constexpr bool is_shared_ptr_v = false;

template <typename T>
inline constexpr bool is_shared_ptr_v<std::shared_ptr<T>> = true;

// Traits is_vector

template <typename T>
inline constexpr bool is_vector_v = false;

template <typename T>
inline constexpr bool is_vector_v<std::vector<T>> = true;

#endif   // PUGS_TRAITS_HPP
