#ifndef EXCEPTIONS_H
#define EXCEPTIONS_H

#include <stdexcept>

struct IExitError : public std::runtime_error
{
  IExitError(std::string_view error_msg) : std::runtime_error(std::string{error_msg}){};

  IExitError(const IExitError&) = delete;
  IExitError(IExitError&&)      = delete;

  virtual ~IExitError() = default;
};

struct RawError : public IExitError
{
  RawError(const RawError&) = delete;
  RawError(RawError&&)      = delete;

  RawError(std::string_view error_msg);
};

struct NormalError : public IExitError
{
  NormalError(const NormalError&) = delete;
  NormalError(NormalError&&)      = delete;

  NormalError(std::string_view error_msg);
};

struct IBacktraceError : public std::runtime_error
{
  IBacktraceError(const IBacktraceError&) = delete;
  IBacktraceError(IBacktraceError&&)      = delete;

  IBacktraceError(const std::string& error_msg) : std::runtime_error(std::string{error_msg}){};
  virtual ~IBacktraceError() = default;
};

struct UnexpectedError : IBacktraceError
{
  UnexpectedError(const UnexpectedError&) = delete;
  UnexpectedError(UnexpectedError&&)      = delete;

  UnexpectedError(std::string_view error_msg);
};

struct NotImplementedError : IBacktraceError
{
  NotImplementedError(const NotImplementedError&) = delete;
  NotImplementedError(NotImplementedError&&)      = delete;

  NotImplementedError(std::string_view error_msg);
};

#endif /* EXCEPTIONS_H */
