#ifndef TUPLE_TO_VECTOR_PROCESSOR_HPP
#define TUPLE_TO_VECTOR_PROCESSOR_HPP

#include <language/ast/ASTNode.hpp>
#include <language/node_processor/INodeProcessor.hpp>

template <typename TupleProcessorT>
class TupleToVectorProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

  std::unique_ptr<TupleProcessorT> m_tuple_processor;

 public:
  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    AggregateDataVariant v = std::get<AggregateDataVariant>(m_tuple_processor->execute(exec_policy));

    v.setIsFlattenable(false);
    return DataVariant{std::move(v)};
  }

  TupleToVectorProcessor(ASTNode& node) : m_node{node}, m_tuple_processor{std::make_unique<TupleProcessorT>(node)} {}

  TupleToVectorProcessor(ASTNode& node, std::unique_ptr<TupleProcessorT>&& tuple_processor)
    : m_node{node}, m_tuple_processor{std::move(tuple_processor)}
  {}
};

#endif   // TUPLE_TO_TINY_VECTOR_PROCESSOR_HPP
