#ifndef EXTERNAL_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define EXTERNAL_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>
#include <utils/Socket.hpp>

#include <memory>

class ExternalBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "external(" << m_name << ',' << *m_boundary_descriptor << ")";
    return os;
  }

  const std::string_view m_name;

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;
  const std::shared_ptr<const Socket> m_socket;

 public:
  std::string_view
  name() const
  {
    return m_name;
  }

  const std::shared_ptr<const Socket>&
  socket() const
  {
    return m_socket;
  }

  const IBoundaryDescriptor&
  boundaryDescriptor() const final
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::external;
  }

  ExternalBoundaryConditionDescriptor(const std::string_view name,
                                      std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor,
                                      const std::shared_ptr<const Socket>& socket)
    : m_name{name}, m_boundary_descriptor(boundary_descriptor), m_socket{socket}
  {}

  ExternalBoundaryConditionDescriptor(const ExternalBoundaryConditionDescriptor&) = delete;
  ExternalBoundaryConditionDescriptor(ExternalBoundaryConditionDescriptor&&)      = delete;

  ~ExternalBoundaryConditionDescriptor() = default;
};

#endif   // EXTERNAL_BOUNDARY_CONDITION_DESCRIPTOR_HPP
