#ifndef VARIATIONAL_SOLVER_O_1HPP
#define VARIATIONAL_SOLVER_O_1HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;

class VariationalSolverO1Handler
{
 public:
  enum class VelocityBCTreatment
  {
    penalty,
    elimination
  };

 private:
  struct IVariationalSolverO1
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const double& dt,
          const VelocityBCTreatment& velocity_bc_treatment,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho,
          const std::shared_ptr<const DiscreteFunctionVariant>& u,
          const std::shared_ptr<const DiscreteFunctionVariant>& E,
          const std::shared_ptr<const DiscreteFunctionVariant>& c,
          const std::shared_ptr<const DiscreteFunctionVariant>& a,
          const std::shared_ptr<const DiscreteFunctionVariant>& p,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const = 0;

    IVariationalSolverO1()                                  = default;
    IVariationalSolverO1(IVariationalSolverO1&&)            = default;
    IVariationalSolverO1& operator=(IVariationalSolverO1&&) = default;

    virtual ~IVariationalSolverO1() = default;
  };

  template <MeshConcept MeshTypeT>
  class VariationalSolverO1;

  std::unique_ptr<IVariationalSolverO1> m_acoustic_solver;

 public:
  const IVariationalSolverO1&
  solver() const
  {
    return *m_acoustic_solver;
  }

  VariationalSolverO1Handler(const std::shared_ptr<const MeshVariant>& mesh);
};

#endif   // VARIATIONAL_SOLVER_O_1HPP
