#ifndef VARIATIONAL_SOLVER_DEVEOPED_RECONSTRUCTION_HPP
#define VARIATIONAL_SOLVER_DEVEOPED_RECONSTRUCTION_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

#warning REMOVE WHEN FLUXES ARE PASSED TO THE LANGUAGE
class FunctionSymbolId;
#include <optional>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;

class VariationalSolverDevelopedReconstructionHandler
{
 public:
  enum class VelocityBCTreatment
  {
    penalty,
    elimination
  };

 private:
  struct IVariationalSolverDevelopedReconstruction
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const size_t& order,
          const double& dt,
          const VelocityBCTreatment& velocity_bc_treatment,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho,
          const std::shared_ptr<const DiscreteFunctionVariant>& u,
          const std::shared_ptr<const DiscreteFunctionVariant>& E,
          const std::shared_ptr<const DiscreteFunctionVariant>& c,
          const std::shared_ptr<const DiscreteFunctionVariant>& a,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
          std::optional<FunctionSymbolId>) const = 0;

    IVariationalSolverDevelopedReconstruction()                                                       = default;
    IVariationalSolverDevelopedReconstruction(IVariationalSolverDevelopedReconstruction&&)            = default;
    IVariationalSolverDevelopedReconstruction& operator=(IVariationalSolverDevelopedReconstruction&&) = default;

    virtual ~IVariationalSolverDevelopedReconstruction() = default;
  };

  template <MeshConcept MeshTypeT>
  class VariationalSolverDevelopedReconstruction;

  std::unique_ptr<IVariationalSolverDevelopedReconstruction> m_acoustic_solver;

 public:
  const IVariationalSolverDevelopedReconstruction&
  solver() const
  {
    return *m_acoustic_solver;
  }

  VariationalSolverDevelopedReconstructionHandler(const std::shared_ptr<const MeshVariant>& mesh);
};

#endif   // VARIATIONAL_SOLVER_DEVEOPED_RECONSTRUCTION_HPP
