#ifndef VARIATIONAL_SOLVER_HPP
#define VARIATIONAL_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

#warning REMOVE WHEN FLUXES ARE PASSED TO THE LANGUAGE
class FunctionSymbolId;
#include <optional>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;

double variational_acoustic_dt(const std::shared_ptr<const DiscreteFunctionVariant>& c);

class VariationalSolverHandler
{
 public:
  enum class VelocityBCTreatment
  {
    penalty,
    elimination
  };

 private:
  struct IVariationalSolver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const size_t& order,
          const double& dt,
          const VelocityBCTreatment& velocity_bc_treatment,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho,
          const std::shared_ptr<const DiscreteFunctionVariant>& u,
          const std::shared_ptr<const DiscreteFunctionVariant>& E,
          const std::shared_ptr<const DiscreteFunctionVariant>& c,
          const std::shared_ptr<const DiscreteFunctionVariant>& a,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
          std::optional<FunctionSymbolId>) const = 0;

    IVariationalSolver()                                = default;
    IVariationalSolver(IVariationalSolver&&)            = default;
    IVariationalSolver& operator=(IVariationalSolver&&) = default;

    virtual ~IVariationalSolver() = default;
  };

  template <MeshConcept MeshTypeT>
  class VariationalSolver;

  std::unique_ptr<IVariationalSolver> m_acoustic_solver;

 public:
  const IVariationalSolver&
  solver() const
  {
    return *m_acoustic_solver;
  }

  VariationalSolverHandler(const std::shared_ptr<const MeshVariant>& mesh);
};

#endif   // VARIATIONAL_SOLVER_HPP
