#ifndef P1P0VARIATIONAL_SOLVER_HPP
#define P1P0VARIATIONAL_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;

class P1P0VariationalSolverHandler
{
 public:
  enum class VelocityBCTreatment
  {
    penalty,
    elimination
  };

 private:
  struct IP1P0VariationalSolver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const double& dt,
          const VelocityBCTreatment& velocity_bc_treatment,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho,
          const std::shared_ptr<const DiscreteFunctionVariant>& u,
          const std::shared_ptr<const DiscreteFunctionVariant>& E,
          const std::shared_ptr<const DiscreteFunctionVariant>& c,
          const std::shared_ptr<const DiscreteFunctionVariant>& a,
          const std::shared_ptr<const DiscreteFunctionVariant>& p,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const = 0;

    IP1P0VariationalSolver()                                    = default;
    IP1P0VariationalSolver(IP1P0VariationalSolver&&)            = default;
    IP1P0VariationalSolver& operator=(IP1P0VariationalSolver&&) = default;

    virtual ~IP1P0VariationalSolver() = default;
  };

  template <MeshConcept MeshTypeT>
  class P1P0VariationalSolver;

  std::unique_ptr<IP1P0VariationalSolver> m_acoustic_solver;

 public:
  const IP1P0VariationalSolver&
  solver() const
  {
    return *m_acoustic_solver;
  }

  P1P0VariationalSolverHandler(const std::shared_ptr<const MeshVariant>& mesh);
};

#endif   // P1P0VARIATIONAL_SOLVER_HPP
