#ifndef P1_P0_ANALYTIC_VARIATIONAL_SOLVER_HPP
#define P1_P0_ANALYTIC_VARIATIONAL_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;

class P1P0AnalyticVariationalSolverHandler
{
 public:
  enum class VelocityBCTreatment
  {
    penalty,
    elimination
  };

 private:
  struct IVariationalSolver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const double& dt,
          const VelocityBCTreatment& velocity_bc_treatment,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho,
          const std::shared_ptr<const DiscreteFunctionVariant>& u,
          const std::shared_ptr<const DiscreteFunctionVariant>& E,
          const std::shared_ptr<const DiscreteFunctionVariant>& c,
          const std::shared_ptr<const DiscreteFunctionVariant>& a,
          const std::shared_ptr<const DiscreteFunctionVariant>& p,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const = 0;

    IVariationalSolver()                     = default;
    IVariationalSolver(IVariationalSolver&&) = default;
    IVariationalSolver& operator=(IVariationalSolver&&) = default;

    virtual ~IVariationalSolver() = default;
  };

  template <MeshConcept MeshType>
  class P1P0AnalyticVariationalSolver;

  std::unique_ptr<IVariationalSolver> m_acoustic_solver;

 public:
  const IVariationalSolver&
  solver() const
  {
    return *m_acoustic_solver;
  }

  P1P0AnalyticVariationalSolverHandler(const std::shared_ptr<const MeshVariant>& mesh);
};

#endif   // P1_P0_ANALYTIC_VARIATIONAL_SOLVER_HPP
