#ifndef INTEGRATION_METHOD_TYPE_HPP
#define INTEGRATION_METHOD_TYPE_HPP

#include <utils/PugsMacros.hpp>

#include <string>

enum class IntegrationMethodType
{
  boundary,      // use divergence theorem to compute polynomial
                 // integrals
  cell_center,   // use exact integrals for degree 1 polynomials
                 // using evaluation at mass center
  element        // use element based quadrature to compute
                 // polynomial integrals
};

std::string PUGS_INLINE
name(const IntegrationMethodType& method_type)
{
  std::string method_name;
  switch (method_type) {
  case IntegrationMethodType::boundary: {
    method_name = "boundary";
    break;
  }
  case IntegrationMethodType::cell_center: {
    method_name = "cell center";
    break;
  }
  case IntegrationMethodType::element: {
    method_name = "element";
  }
  }
  return method_name;
}

#endif   // INTEGRATION_METHOD_TYPE_HPP
