#ifndef ARRAY_UTILS_HPP
#define ARRAY_UTILS_HPP

#include <PastisMacros.hpp>
#include <Kokkos_Core.hpp>

template <typename ArrayType>
class ReduceMin
{
 private:
  const ArrayType& m_array;
  using data_type = std::remove_const_t<typename ArrayType::data_type>;
  using index_type = typename ArrayType::index_type;

 public:
  PASTIS_INLINE
  operator data_type()
  {
    data_type reduced_value;
    Kokkos::parallel_reduce(m_array.size(), *this, reduced_value);
    return reduced_value;
  }

  PASTIS_INLINE
  void operator()(const index_type& i, data_type& data) const
  {
    if (m_array[i] < data) {
      data = m_array[i];
    }
  }

  PASTIS_INLINE
  void join(volatile data_type& dst,
            const volatile data_type& src) const
  {
    if (src < dst) {
      dst = src;
    }
  }

  PASTIS_INLINE
  void init(data_type& value) const
  {
    value = std::numeric_limits<data_type>::max();
  }

  PASTIS_INLINE
  ReduceMin(const ArrayType& array)
      : m_array(array)
  {
    ;
  }

  PASTIS_INLINE
  ~ReduceMin() = default;
};


template <typename ArrayType>
class ReduceMax
{
 private:
  const ArrayType& m_array;
  using data_type = std::remove_const_t<typename ArrayType::data_type>;
  using index_type = typename ArrayType::index_type;

 public:
  PASTIS_INLINE
  operator data_type()
  {
    data_type reduced_value;
    Kokkos::parallel_reduce(m_array.size(), *this, reduced_value);
    return reduced_value;
  }

  PASTIS_INLINE
  void operator()(const index_type& i, data_type& data) const
  {
    if (m_array[i] > data) {
      data = m_array[i];
    }
  }

  PASTIS_INLINE
  void join(volatile data_type& dst,
            const volatile data_type& src) const
  {
    if (src > dst) {
      dst = src;
    }
  }

  PASTIS_INLINE
  void init(data_type& value) const
  {
    value = -std::numeric_limits<data_type>::max();
  }

  PASTIS_INLINE
  ReduceMax(const ArrayType& array)
      : m_array(array)
  {
    ;
  }

  PASTIS_INLINE
  ~ReduceMax() = default;
};

#endif //ARRAY_UTILS_HPP
