#include <language/utils/BinaryOperatorRegisterForString.hpp>

#include <language/utils/BinaryOperatorProcessorBuilder.hpp>
#include <language/utils/ConcatExpressionProcessorBuilder.hpp>
#include <language/utils/OperatorRepository.hpp>

void
BinaryOperatorRegisterForString::_register_comparisons()
{
  OperatorRepository& repository = OperatorRepository::instance();

  repository.addBinaryOperator<language::eqeq_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::eqeq_op, bool, std::string, std::string>>());

  repository.addBinaryOperator<language::not_eq_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::not_eq_op, bool, std::string, std::string>>());
}

template <typename RHS_T>
void
BinaryOperatorRegisterForString::_register_concat()
{
  OperatorRepository& repository = OperatorRepository::instance();

  repository.addBinaryOperator<language::plus_op>(std::make_shared<ConcatExpressionProcessorBuilder<RHS_T>>());
}

BinaryOperatorRegisterForString::BinaryOperatorRegisterForString()
{
  this->_register_comparisons();

  this->_register_concat<bool>();
  this->_register_concat<unsigned long>();
  this->_register_concat<long>();
  this->_register_concat<double>();
  this->_register_concat<TinyVector<1>>();
  this->_register_concat<TinyVector<2>>();
  this->_register_concat<TinyVector<3>>();
  this->_register_concat<TinyMatrix<1>>();
  this->_register_concat<TinyMatrix<2>>();
  this->_register_concat<TinyMatrix<3>>();
  this->_register_concat<std::string>();
}
