#ifndef SCHEME_MODULE_HPP
#define SCHEME_MODULE_HPP

#include <language/modules/BuiltinModule.hpp>
#include <language/utils/ASTNodeDataTypeTraits.hpp>
#include <utils/PugsMacros.hpp>

class IBoundaryDescriptor;
template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const IBoundaryDescriptor>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("boundary");

class IBoundaryConditionDescriptor;
template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const IBoundaryConditionDescriptor>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("boundary_condition");

class IDiscreteFunction;
template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const IDiscreteFunction>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("Vh");

class IDiscreteFunctionDescriptor;
template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const IDiscreteFunctionDescriptor>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("Vh_type");

class SchemeModule : public BuiltinModule
{
 public:
  std::string_view
  name() const final
  {
    return "scheme";
  }

  void registerOperators() const final;

  SchemeModule();

  ~SchemeModule() = default;
};

#endif   // SCHEME_MODULE_HPP
