#ifndef PASTIS_ASSERT_HPP
#define PASTIS_ASSERT_HPP

#include <rang.hpp>
#include <iostream>
#include <string>

class AssertError
{
 private:
  const std::string m_file;
  const int m_line;
  const std::string m_function;
  const std::string m_message;

 public:
  friend
  std::ostream& operator<<(std::ostream& os,
                           const AssertError& assert_error)
  {
    os << '\n'
       << rang::style::bold
       << "*** Assertion error ***\n"
       << " at " << assert_error.m_file << ':' << assert_error.m_line << '\n'
       << " in " << assert_error.m_function << '\n'
       << "*** " << rang::fgB::red << assert_error.m_message << rang::fg::reset
       << rang::style::reset << '\n';

    return os;
  }

  AssertError(const AssertError&) = default;
  AssertError(std::string file,
              int line,
              std::string function,
              std::string message)
      : m_file(file),
        m_line(line),
        m_function(function),
        m_message(message)
  {
    ;
  }

  ~AssertError() = default;
};

#ifdef NDEBUG

#warning check that this test does not degrade performaces
#define Assert(assertion)                       \
  if (not (assertion)) false;

#else // NDEBUG

#define Assert(assertion)                                               \
  if (not (assertion)) {                                                \
    throw AssertError(__FILE__,                                         \
                      __LINE__,                                         \
                      __PRETTY_FUNCTION__,                              \
                      (#assertion));                                    \
  }

#endif // NDEBUG

#endif // PASTIS_ASSERT_HPP
