#include <dev_utils/ParallelChecker.hpp>

ParallelChecker* ParallelChecker::m_instance = nullptr;

void
ParallelChecker::create()
{
  Assert(ParallelChecker::m_instance == nullptr, "ParallelChecker has already been created");
  ParallelChecker::m_instance = new ParallelChecker;
}

void
ParallelChecker::destroy()
{
  Assert(ParallelChecker::m_instance != nullptr, "ParallelChecker has already been destroyed");
  delete ParallelChecker::m_instance;
}

void
parallel_check(const ItemValueVariant& item_value_variant,
               const std::string& name,
               const SourceLocation& source_location)
{
  std::visit([&](auto&& item_value) { parallel_check(item_value, name, source_location); },
             item_value_variant.itemValue());
}

void
parallel_check(const DiscreteFunctionVariant& discrete_function_variant,
               const std::string& name,
               const SourceLocation& source_location)
{
  std::visit([&](auto&& discrete_function) { parallel_check(discrete_function, name, source_location); },
             discrete_function_variant.discreteFunction());
}
