#include <BuildInfo.hpp>
#include <pastis_config.hpp>
#include <pastis_build_info.hpp>

#include <sstream>

#ifdef PASTIS_HAS_MPI
#include <mpi.h>
#endif //  PASTIS_HAS_MPI

std::string BuildInfo::type()
{
  return PASTIS_BUILD_TYPE;
}

std::string BuildInfo::compiler()
{
  std::stringstream compiler_info;
  compiler_info << PASTIS_BUILD_COMPILER
                << " (" << PASTIS_BUILD_COMPILER_VERSION
                << ")" << std::ends;
  return compiler_info.str();
}

std::string BuildInfo::kokkosDevices()
{
  return PASTIS_BUILD_KOKKOS_DEVICES;
}

std::string BuildInfo::mpiLibrary()
{
#ifdef PASTIS_HAS_MPI
  return [](){
           int length;
           char mpi_version[MPI_MAX_LIBRARY_VERSION_STRING];
           MPI_Get_library_version(mpi_version, &length);
           return std::string(mpi_version);
         }();
#else
  return "none";
#endif // PASTIS_HAS_MPI
}
