#ifndef DISCRETE_FUNCTION_P0_HPP
#define DISCRETE_FUNCTION_P0_HPP

#include <scheme/IDiscreteFunction.hpp>

#include <language/utils/InterpolateItemValue.hpp>
#include <mesh/Connectivity.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshDataManager.hpp>
#include <scheme/DiscreteFunctionDescriptorP0.hpp>

template <size_t Dimension, typename DataType>
class DiscreteFunctionP0 : public IDiscreteFunction
{
 private:
  using MeshType = Mesh<Connectivity<Dimension>>;

  std::shared_ptr<const MeshType> m_mesh;
  CellValue<DataType> m_cell_values;

  DiscreteFunctionDescriptorP0 m_discrete_function_descriptor;

 public:
  ASTNodeDataType
  dataType() const final
  {
    return ast_node_data_type_from<DataType>;
  }

  CellValue<DataType>
  cellValues() const
  {
    return m_cell_values;
  }

  std::shared_ptr<const IMesh>
  mesh() const
  {
    return m_mesh;
  }

  const IDiscreteFunctionDescriptor&
  descriptor() const final
  {
    return m_discrete_function_descriptor;
  }

  PUGS_FORCEINLINE
  DataType&
  operator[](const CellId& cell_id) const noexcept(NO_ASSERT)
  {
    return m_cell_values[cell_id];
  }

  DiscreteFunctionP0(const std::shared_ptr<const MeshType>& mesh, const FunctionSymbolId& function_id) : m_mesh(mesh)
  {
    using MeshDataType      = MeshData<Dimension>;
    MeshDataType& mesh_data = MeshDataManager::instance().getMeshData(*mesh);

    m_cell_values =
      InterpolateItemValue<DataType(TinyVector<Dimension>)>::template interpolate<ItemType::cell>(function_id,
                                                                                                  mesh_data.xj());
  }

  DiscreteFunctionP0(const DiscreteFunctionP0&) noexcept = default;
  DiscreteFunctionP0(DiscreteFunctionP0&&) noexcept      = default;

  ~DiscreteFunctionP0() = default;
};

#endif   // DISCRETE_FUNCTION_P0_HPP
