#ifndef MESH_BUILDER_BASE_HPP
#define MESH_BUILDER_BASE_HPP

#include <mesh/IMesh.hpp>

#include <memory>

class MeshBuilderBase
{
 protected:
  std::shared_ptr<const IMesh> m_mesh;

  template <int Dimension>
  void _dispatch();

 public:
  std::shared_ptr<const IMesh>
  mesh() const
  {
    return m_mesh;
  }

  MeshBuilderBase()  = default;
  ~MeshBuilderBase() = default;
};

#endif   // MESH_BUILDER_BASE_HPP
