#include <mesh/DiamondDualMeshManager.hpp>

#include <mesh/Connectivity.hpp>
#include <mesh/DiamondDualMeshBuilder.hpp>
#include <mesh/Mesh.hpp>
#include <utils/Exceptions.hpp>
#include <utils/PugsAssert.hpp>

#include <sstream>

DiamondDualMeshManager* DiamondDualMeshManager::m_instance{nullptr};

void
DiamondDualMeshManager::create()
{
  Assert(m_instance == nullptr, "DiamondDualMeshManager is already created");
  m_instance = new DiamondDualMeshManager;
}

void
DiamondDualMeshManager::destroy()
{
  Assert(m_instance != nullptr, "DiamondDualMeshManager was not created!");

  if (m_instance->m_mesh_to_diamond_dual_mesh_map.size() > 0) {
    std::stringstream error;
    error << ": some meshes are still registered\n";
    for (const auto& i_mesh_data : m_instance->m_mesh_to_diamond_dual_mesh_map) {
      error << " - mesh " << rang::fgB::magenta << i_mesh_data.first << rang::style::reset << '\n';
    }
    throw UnexpectedError(error.str());
  }
  delete m_instance;
  m_instance = nullptr;
}

void
DiamondDualMeshManager::deleteMesh(const IMesh* p_mesh)
{
  m_mesh_to_diamond_dual_mesh_map.erase(p_mesh);
}

template <size_t Dimension>
std::shared_ptr<const Mesh<Connectivity<Dimension>>>
DiamondDualMeshManager::getDiamondDualMesh(std::shared_ptr<const Mesh<Connectivity<Dimension>>> mesh)
{
  const IMesh* p_mesh = mesh.get();

  if (auto i_mesh_data = m_mesh_to_diamond_dual_mesh_map.find(p_mesh);
      i_mesh_data != m_mesh_to_diamond_dual_mesh_map.end()) {
    return std::dynamic_pointer_cast<const Mesh<Connectivity<Dimension>>>(i_mesh_data->second);
  } else {
    DiamondDualMeshBuilder builder{mesh};

    m_mesh_to_diamond_dual_mesh_map[p_mesh] = builder.mesh();
    return std::dynamic_pointer_cast<const Mesh<Connectivity<Dimension>>>(builder.mesh());
  }
}

template std::shared_ptr<const Mesh<Connectivity<1>>> DiamondDualMeshManager::getDiamondDualMesh(
  std::shared_ptr<const Mesh<Connectivity<1>>>);
template std::shared_ptr<const Mesh<Connectivity<2>>> DiamondDualMeshManager::getDiamondDualMesh(
  std::shared_ptr<const Mesh<Connectivity<2>>>);
template std::shared_ptr<const Mesh<Connectivity<3>>> DiamondDualMeshManager::getDiamondDualMesh(
  std::shared_ptr<const Mesh<Connectivity<3>>>);
