#ifndef CONNECTIVITY_COMPUTER_HPP
#define CONNECTIVITY_COMPUTER_HPP

#include <mesh/ConnectivityMatrix.hpp>
#include <mesh/SubItemValuePerItem.hpp>

class ConnectivityComputer
{
 private:
  ConnectivityMatrix _computeInverse(const ConnectivityMatrix& item_to_child_matrix) const;

 public:
  template <typename ConnectivityType>
  ConnectivityMatrix computeConnectivityMatrix(const ConnectivityType& connectivity,
                                               ItemType item_type,
                                               ItemType child_item_type) const;

  template <typename ItemOfItem, typename ConnectivityType>
  WeakSubItemValuePerItem<const unsigned short, typename ItemOfItem::Reversed> computeLocalItemNumberInChildItem(
    const ConnectivityType& connectivity) const;

  ConnectivityComputer(const ConnectivityComputer&) = default;
  ConnectivityComputer()                            = default;
  ~ConnectivityComputer()                           = default;
};

#endif   // CONNECTIVITY_COMPUTER_HPP
